//
//  Handy_Harp_ClientApp.swift
//  Handy Harp Client
//  
//  Created by KIRA Ryouta on 2025/11/15.
//
/*
 MIT License

 Copyright (c) 2025-2026 PROCYON STUDIO CO., LTD.
 Copyright (c) 2025-2026 KIRA Ryouta

 Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

import SwiftUI
import AppKit
import Combine

extension NSNotification.Name {
    static let applictionDidHandleReopen = NSNotification.Name("applictionDidHandleReopen")
}

class AppDelegate: NSObject, NSApplicationDelegate {

    func applicationShouldHandleReopen(_ sender: NSApplication, hasVisibleWindows flag: Bool) -> Bool {
        // Dock クリック時、または二度起動時
        NotificationCenter.default.post(name: .applictionDidHandleReopen, object: self)
        return true
    }
}

@main
struct Handy_Harp_ClientApp: App {
    @NSApplicationDelegateAdaptor(AppDelegate.self) var appDelegate
    @Environment(\.openWindow) private var openWindow
    @StateObject private var object = MainObject()

    static private func makeTrayNSImage() -> NSImage {
        return {
            $0.size.width = 18
            $0.size.height = 18
            return $0
        }(NSImage(named: "T_Icon_HandyHarp")!)
    }

    static let trayNSImage = makeTrayNSImage()

    static private func makeConnectedImage() -> Image {
        let base = trayNSImage.copy() as! NSImage
        let path = NSBezierPath(ovalIn: NSRect(x: base.size.width - 5, y: 0, width: 5, height: 5))

        base.lockFocus()
        path.fill()
        base.unlockFocus()

        return Image(nsImage: base)
            .renderingMode(.template)
    }

    static let connectedImage = makeConnectedImage()

    func openExistWindow(id: String) {
        var windowExists: Bool = false
        NSApplication.shared.activate(ignoringOtherApps: true)
        NSApplication.shared.windows.forEach { window in
            if let exists = window.identifier?.rawValue.starts(with: id), exists {
                window.makeKeyAndOrderFront(nil)
                window.orderFrontRegardless()
                windowExists = true
            }
        }
        if (!windowExists) {
            openWindow(id: id)
        }
    }

    var body: some Scene {
        MenuBarExtra {
            Text("Status: \(object.connected ? "Connected" : "Not Connected")")
            Divider()
            Button("About") {
                openExistWindow(id: "about")
            }
            Divider()
            Button("Quit") {
                NSApplication.shared.terminate(nil)
            }
        } label: {
            VStack {
                if object.connected {
                    Handy_Harp_ClientApp.connectedImage
                }
                else {
                    Image(nsImage: Handy_Harp_ClientApp.trayNSImage)
                }
            }
            .onReceive(NotificationCenter.default.publisher(for: .applictionDidHandleReopen)) { _ in
                openExistWindow(id: "about")
            }
        }
        WindowGroup(id: "about") {
            AboutView()
        }
        .windowResizability(.contentSize)
    }
}
